;==============================================================================;
;==	HID Bootloader									Create Date 2018/02/12
;==	pic16f145x_family								Last Update 2018/04/03
;==	file name	: main.asm									Saka Softwares
;==	Assemblr	; MPASMWIN v5.77
;==	Tab = 4
;==============================================================================;
;== マイクロチップ社製HID Bootloader と互換が有りWindows等のアプリが
;== そのまま使えます。0x500Word以内に納めています。
;== 純正Ver1.02相当/Winアプリv2.15に対応しました。
;== 書き込みには、「HIDBootloader.exe」のv2.9j以降のWindowsアプリを
;== 使用します。以前のアプリでは、新機能が働かずブートローラーからユー
;== ザープログラムを起動できません。
;== 
;==============================================================================;
;== File Version ==============================================================;
#define	Version		0x0100					; BCD表現のバージョン No.	
;== 1.00		2018/04/03	初期公開版です。
;== 0.01		2018/02/12	初期バージョン
;==		
;== Include ===================================================================;
#include "PicConfig.inc"					; コンフィグワードを記載しています。
#include "HardwareProfile.inc"				; ボードに合わせて修正してください。
#include "bootloader.inc"					; プードローダ処理
#include "usbhiddrv.inc"					; USB HID処理

	radix	dec
;== Variables =================================================================;
MAINDATA		UDATA
mCOUNT	res 3								; カウント処理用
	
;== Vectors ===================================================================;
POWER_ON		CODE	0x0000				; processor reset vector
		nop
		movlp	0							; PCLATH = 0
		goto	StartUp						; go to beginning of program
		dw		Version						; Version (BCD code)
ISR				CODE	0x0004				; interrupt vector location
		movlp	high REMAPPED_ISR_VECTOR
		goto	REMAPPED_ISR_VECTOR			; go to User ISR
		
;== Declarations ==============================================================;
MAINCODE		CODE	0x0006				; Program Entry
;==============================================================================;
;====	スタートアップ
;==============================================================================;
StartUp:
		movlb	0							; Bank 0
#ifdef	BOOTLOADER_SW2_ON
		btfss	pSW2						; ブートローダースイッチが押されてるか?
		bra		Bootloader
#endif
FlashSignatureCheck:
		BANKSEL	PMCON1						; Bank 3
		bcf		PMCON1, CFGS
		movlw	low  (APP_SIGNATURE_ADDRESS)
		movwf	PMADRL
		movlw	high (APP_SIGNATURE_ADDRESS)
		movwf	PMADRH						; アドレスをセット
		bsf		PMCON1, RD
		nop
		nop
		movf	PMDATL, W
		sublw	APP_SIGNATURE_VALUE			; GOODコードか？
		bnz		Bootloader
		movf	PMDATH, W
		sublw	RETLW_OPCODE_MSB			; OPコードか？
		bnz		Bootloader
		bra		FlashRemapResetVectorCheck	; ユーザーアドレス検査へ
	
;==============================================================================;
;==		プートローダー開始アドレス (0x001C)
;==============================================================================;
BOOTLOADERCODE	CODE	BOOTLOADER_ENTRY_ADDRESS
;==============================================================================;
Bootloader:
		clrwdt								; ウォッチドックタイマのクリア
		clrf	INTCON						; 割り込みの禁止
		clrf	STKPTR						; スタックポインタの初期化
		BANKSEL	WDTCON						; Bank 1
		movlw	0x17
		movwf	WDTCON						; ウォッチドック起動（2s）
#ifdef	INTERNAL_USB_CLOCK
InterNal_USB_Clock:						; 内部USBクロック使用時
		movlw	0xFC
		movwf	OSCCON						; 3x PLL enabled from 16MHz HFINTOSC
PLL_Redy_loop:							; 内部USBクロックの安定待ち
		btfss	OSCSTAT, PLLRDY
		bra		PLL_Redy_loop				; Wait for PLL lock
		BANKSEL	ACTCON						; Bank7
		movlw	0x90
		movwf	ACTCON						; Enable active clock tuning for USB operation
#endif
#ifdef BOOTLOADER_LED_ON
		movlb	2							; Bank 2
		bcf		pLED1						; LED1 消灯
		movlb	1							; Bank 1
		bcf		tLED1						; LED1 初期化
#endif
		movlb	0							; Bank 0
		call	USBDeviceInit				; USBの初期化
		call	BootlodarInit				; ブートローダーの初期化
;==============================================================================;
;====	メインループ
;==============================================================================;
main:
		clrwdt								; ウォッチドックタイマのクリア
		call	USBDeviceTasks				; USBタスク処理
		bnz		main						; 通信中か?(Z=1:通信中)
#ifdef	BOOTLOADER_LED_ON
		movlb	2							; Bank 2
		bsf		pLED1						; LED1 点灯
		movlb	0							; Bank 0
#endif
		call	BootlodarTasks
		bra		main						; 無限ループ

;==============================================================================;
;==		ユーザー領域検査
;==============================================================================;
FlashRemapResetVectorCheck:
		BANKSEL	PMADRL
		movlw	low  (REMAPPED_RESET_VECTOR)
		movwf	PMADRL
		movlw	high (REMAPPED_RESET_VECTOR)
		movwf	PMADRH
		bsf		PMCON1, RD
		nop
		nop
		movf	PMDATL, W
		sublw	low  (BLANK_FLASH_WORD_VALUE)
		bnz		GotoUserApplication
		movf	PMDATH, W
		sublw	high (BLANK_FLASH_WORD_VALUE)
		bz		Bootloader
GotoUserApplication:
		movlb	0							; Bank 0
		movlp	high (REMAPPED_RESET_VECTOR)
		goto	REMAPPED_RESET_VECTOR		; ユーザープログラムへ

;==============================================================================;
;==		メインリセット
;==============================================================================;
Main_Reset:								; bootloader.asm で使います。
		global	Main_Reset
#ifdef BOOTLOADER_LED_ON
		movlb	2							; Bank 2
		bcf		pLED1						; LED1 消灯
#endif
		BANKSEL	mCOUNT
		movlw	20
		movwf	(mCOUNT+0)
		movwf	(mCOUNT+1)
		movwf	(mCOUNT+2)
Main_Reset_Loop:
		clrwdt								; ウォッチドックタイマのクリア
		call	USBDeviceTasks				; USBタスク処理
		decfsz	(mCOUNT+0), F
		goto	Main_Reset_Loop
		BANKSEL	UCON
		clrf	UCON						; USBの停止
		BANKSEL	mCOUNT
		decfsz	(mCOUNT+1), F
		goto	Main_Reset_Loop
		decfsz	(mCOUNT+2), F
		goto	Main_Reset_Loop
		reset								; リセット

;==============================================================================;
;==		ユーザーコード領域
;==============================================================================;
SIGNATURE		CODE	APP_SIGNATURE_ADDRESS
;==============================================================================;
		retlw	APP_SIGNATURE_VALUE			; ブートサインを記入
;==============================================================================;
		END